#!/usr/bin/env python
# Start Saving Messages

# Copyright 2004 by Brian C. Christensen

#    This file is part of GanttPV.
#
#    GanttPV is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    GanttPV is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with GanttPV; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# 050820 - first version of this script

import sys

def hint(s):
    try:
        Data.Hint("%s: %s" % (scriptname, s))
    except AttributeError:
        self.SetStatusText(s)

class MessageText:
    text = ""
    def write(self, string):
        self.text += string
    def clear(self):
        self.text = ""

def StartSavingMessages(self):
    if hasattr(Data, "MessageText"):
        hint("Start Saving Messages has already been run.")
        return

    tt = MessageText()
    Data.MessageText = tt
    # set stdout to tt
    tt.stdout = sys.stdout
    sys.stdout = tt
    tt.stderr = sys.stderr
    sys.stderr = tt

StartSavingMessages(self)

    # f = open("Main.py", "r")
    # msg = f.read()
    # f.close()
